// Submitted by Dr. Triranjita Srivastava. Assistant Professor, Physics Dept., Kalindi College, University of Delhi

//Operating system: Windows 8
//SCILAB Ver: 5.5.2

// Objective: To study computer graphics. 
// One can create any object of choice and implement various tranformations, like, Shear, Strain, 2D rotation, Reflection, Translation, 

clc
clear
//************************************************************
//Creation of an object (say, rectangle)
//************************************************************
x=[0,5,5,0,0]
y=[0,0,3,3,0]
N=[x;y]

//************************************************************
//To Study Shear
//************************************************************
l=input("Enter 1, 2 or 3 for shear along x- axis, y-axis or both axis, respectively: ")

figure(1)
xlabel('x-coordinates (cm)','fontsize',5)
ylabel('y-coordinates (cm)','fontsize',5)
a=get("current_axes")       //get the handle of the newly created axes
a.font_size=4
t=get("hdl")                //get the handle of the newly created object
t.font_size=5

select l
    case 1
        // Transformation Matrix for Shear parallel to x-axis
        s=input("Enter the value of shear s =  ")
        Sx=[1 s; 0 1]
        S=Sx*N
        title('Shear parallel to x-axis','fontsize',5)
        a.data_bounds=[0,0;8,5]
    case 2
        // Transformation Matrix for Shear parallel to y-axis
        s=input("Enter the value of shear s =  ")
        Sy=[1 0; s 1]
        S=Sy*N
        title('Shear parallel to y-axis','fontsize',5)
        a.data_bounds=[0,0;6,8]
    case 3
        // Transformation Matrix for Shear in x and y-direction
        sx=input("Enter the value of shear in x-direction sx =  ")
        sy=input("Enter the value of shear in y-direction sy =  ")
        Sxy=[1 sx; sy 1]
        S=Sxy*N
        title('Shear in x and y direction','fontsize',5)
        a.data_bounds=[0,0;6,8]
end
plot(x,y,'linewidth',3)
plot(S(1,:),S(2,:),'--r','linewidth',3)
hl=legend(['old coordinates';'new coordinates'])
h1.font_size=3


//************************************************************
//To Study Strain
//************************************************************

p=input("Enter 1 or 2 for strain along x- axis or y-axis, respectively: ")

figure(2)
xlabel('x-coordinates (cm)','fontsize',5)
ylabel('y-coordinates (cm)','fontsize',5)
a=get("current_axes");  //get the handle of the newly created axes
a.font_size=4
t=get("hdl")   //get the handle of the newly created object
t.font_size=5;

select p
    case 1
//         Transformation Matrix for Strain along x-axis
        stx=input("Enter the value of strain stx = ")
        Str_x=[stx 0; 0 1]
        ST=Str_x*N;
        title('Strain along x-axis','fontsize',5);
        a.data_bounds=[0,0;8,5];
    case 2
//         Transformation Matrix for strain along y-axis
        sty=input("Enter the value of strain sty = ")
        Str_y=[1 0; 0 sty]
        ST=Str_y*N;
        title('Strain along y-axis','fontsize',5);
        a.data_bounds=[0,0;6,8];
end
plot(x,y,'linewidth',3);
plot(ST(1,:),ST(2,:),'--r','linewidth',3)
hl=legend(['old coordinates';'new coordinates']);
h1.font_size=3



//************************************************************
//To Study 2D Rotation
//************************************************************

k=input("Enter 1 or 2 for 2D Rotation in clockwise and anticlockwise direction, respectively: ")
th=input("Enter the required angle for rotation th (in degree) = ")
figure(3)
xlabel('x-coordinates (cm)','fontsize',5)
ylabel('y-coordinates (cm)','fontsize',5)
a=get("current_axes");//get the handle of the newly created axes
a.font_size=4
t=get("hdl")   //get the handle of the newly created object
t.font_size=5;

select k
    case 1
        // Transformation Matrix for Rotation in clockwise direction
        Cl=[cosd(th),sind(th);-sind(th),cosd(th)]
        Rot=Cl*N;
        title('Rotation in clockwise direction','fontsize',5);
        a.data_bounds=[0,0;8,5];
    case 2
        // Transformation Matrix for Rotation in anticlockwise direction
        Anti=[cosd(th),-sind(th);sind(th),cosd(th)]
        Rot=Anti*N;
        title('Rotation in anticlockwise direction','fontsize',5);
        a.data_bounds=[0,0;6,8];
end
plot(x,y,'linewidth',3);
plot(Rot(1,:),Rot(2,:),'--r','linewidth',3)
hl=legend(['old coordinates';'new coordinates']);
h1.font_size=3

//************************************************************
//To Study the reflection
//************************************************************
j=input("Enter 1, 2 or 3 for reflection about x- axis, y-axis or origin, respectively: ")

figure(4)
xlabel('x-coordinates (cm)','fontsize',5)
ylabel('y-coordinates (cm)','fontsize',5)

a=get("current_axes");//get the handle of the newly created axes
a.font_size=4
t=get("hdl")   //get the handle of the newly created object
t.font_size=5;
select j
    case 1
    // Transformation Matrix for Reflection about x-axis
        Rx=[1 0; 0 -1]
        R=Rx*N;
        title('Reflection about x-axis','fontsize',5);
        a.data_bounds=[0,-4;6,4];
    case 2
    // Transformation Matrix for Reflection about y-axis
        Ry=[-1 0; 0 1]
        R=Ry*N;
        title('Reflection about y-axis','fontsize',5);
        a.data_bounds=[0,0;8,4];
    case 3 
        //Transformation Matrix for Reflection about origin
        Rxy=[-1 0; 0 -1]
        R=Rxy*N;
        title('Reflection about origin','fontsize',5);
        a.data_bounds=[-8,-5;8,5];
end

plot(x,y,'linewidth',3);
plot(R(1,:),R(2,:),'--r','linewidth',3)
hl=legend(['old coordinates';'new coordinates']);
h1.font_size=5

//************************************************************
//To Study translation
//************************************************************
i=input("Enter 1, 2 or 3 for translation along x- axis, y-axis or both directions, respectively: ")

figure(5)
xlabel('x-coordinates (cm)','fontsize',5)
ylabel('y-coordinates (cm)','fontsize',5)
a=get("current_axes");   //get the handle of the newly created axes
a.font_size=4
t=get("hdl")   //get the handle of the newly created object
t.font_size=5;

select i
    case 1
        // Transformation Matrix for translation along to x-axis
        tx=input("Enter the required translation along x direction tx =  ")
        T1=[ones(1,length(x));zeros(1,length(x))];
        X=N+tx*T1;
        title('Translation along to x-axis','fontsize',5);
        a.data_bounds=[0,0;8,5];
    case 2
        // Transformation Matrix for translation along to y-axis
        ty=input("Enter the the required translation along x direction ty =  ")
        T1=[zeros(1,length(x));ones(1,length(x))];
        X=N+ty*T1;
        title('Translation along to y-axis','fontsize',5);
        a.data_bounds=[0,0;6,8];
    case 3
        // Transformation Matrix for translation along to y-axis
        tx=input("Enter the required translation along x direction tx =  ")
        ty=input("Enter the required translation along y direction ty =  ")
        T1=[ones(1,length(x));zeros(1,length(x))];
        T2=[zeros(1,length(x));ones(1,length(x))];
        X=N+tx*T1+ty*T2;
        title('Translation along to y-axis','fontsize',5);
        a.data_bounds=[0,0;6,8];
end
plot(x,y,'linewidth',3);
plot(X(1,:),X(2,:),'--r','linewidth',3)
hl=legend(['old coordinates';'new coordinates']);
h1.font_size=3
